/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.GameControl;
import data.Constants;
import data.Theme;
import java.util.ArrayList;
import model.EnemyModel;
import model.PlayerModel;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import view.BackgroundDrawer;
import view.StaticDrawer;

public class EnemyControl {
    public ArrayList<EnemyModel> enemies;
    float goalX;
    float goalY;
    private static boolean enemyMoving;
    public static float xVel;
    public static float yVel;
    private float tempSat;
    private static int moveGrace;
    private GameControl gc;

    static {
        moveGrace = 0;
    }

    public EnemyControl(int maxEnemies, GameControl gc) {
        this.enemies = new ArrayList(maxEnemies);
        enemyMoving = false;
        yVel = 0.0f;
        xVel = 0.0f;
        this.gc = gc;
    }

    public boolean allEnemiesDead() {
        return this.enemies.isEmpty();
    }

    public void add(EnemyModel e) {
        this.enemies.add(e);
    }

    public void delete(EnemyModel e) {
        this.enemies.remove(e);
        e = null;
    }

    public void move(float playerX, float playerY) {
        if (this.isEnemyMoving()) {
            this.applyFriction();
            int i = 0;
            while (i < this.enemies.size()) {
                if (this.enemies.get(i) != null) {
                    this.enemies.get(i).seekPlayer(playerX, playerY);
                    this.enemies.get(i).move(xVel, yVel);
                    if (this.enemies.size() > 200) {
                        this.enemies.get(i).age();
                        this.enemies.get(i).age();
                        this.enemies.get(i).age();
                    } else {
                        this.enemies.get(i).age();
                    }
                }
                ++i;
            }
        }
    }

    public float computeDirectionAngle() {
        if (xVel == 0.0f && yVel > 0.0f) {
            return 4.712389f;
        }
        if (xVel == 0.0f && yVel < 0.0f) {
            return 1.5707964f;
        }
        if (xVel > 0.0f && yVel == 0.0f) {
            return (float)Math.PI;
        }
        if (xVel < 0.0f && yVel == 0.0f) {
            return 0.0f;
        }
        float theta = (float)Math.atan(Math.abs(yVel) / Math.abs(xVel));
        if (xVel > 0.0f && yVel > 0.0f) {
            return (float)(Math.PI + (double)theta);
        }
        if (xVel > 0.0f && yVel < 0.0f) {
            return (float)(Math.PI - (double)theta);
        }
        if (xVel < 0.0f && yVel < 0.0f) {
            return theta;
        }
        if (xVel < 0.0f && yVel > 0.0f) {
            return -theta;
        }
        return 0.0f;
    }

    public float computeGain() {
        float gain = 0.0f;
        float z = (float)Math.sqrt(xVel * xVel + yVel * yVel);
        gain = (double)z >= (double)Constants.MAX_PLAYER_SPEED * 0.25 ? 0.0f : (1.0f - z / Constants.MAX_PLAYER_SPEED) * -35.0f;
        return gain;
    }

    public void applyFriction() {
        if (xVel > 0.0f && (xVel -= Constants.PLAYER_SPEED_FRICTION) < 0.0f) {
            xVel = 0.0f;
        }
        if (xVel < 0.0f && (xVel += Constants.PLAYER_SPEED_FRICTION) > 0.0f) {
            xVel = 0.0f;
        }
        if (yVel > 0.0f && (yVel -= Constants.PLAYER_SPEED_FRICTION) < 0.0f) {
            yVel = 0.0f;
        }
        if (yVel < 0.0f && (yVel += Constants.PLAYER_SPEED_FRICTION) > 0.0f) {
            yVel = 0.0f;
        }
    }

    public float checkCollisions(PlayerModel p) {
        this.tempSat = 0.0f;
        int i = 0;
        while (i < this.enemies.size()) {
            float satChange = this.enemies.get(i).collide(p);
            this.tempSat += satChange;
            ++i;
        }
        return this.tempSat;
    }

    public void draw(float k) {
        GL11.glEnable(3042);
        Theme.useThemeBlendingFunction();
        if (Theme.currentTheme == Theme.GLOW_THEME) {
            GL11.glEnable(3553);
            StaticDrawer.texture.bind();
            int i = 0;
            while (i < this.enemies.size()) {
                if (this.enemies.get(i) != null) {
                    this.enemies.get(i).draw(k);
                }
                ++i;
            }
            GL11.glDisable(3553);
        } else if (Theme.currentTheme == Theme.SQUARE_THEME) {
            int i = 0;
            while (i < this.enemies.size()) {
                if (this.enemies.get(i) != null) {
                    this.enemies.get(i).draw(k);
                }
                ++i;
            }
        }
        GL11.glDisable(3042);
    }

    public boolean isEnemyMoving() {
        if (xVel != 0.0f || yVel != 0.0f) {
            if (Keyboard.isKeyDown(2)) {
                this.gc.getSoundController().setGainShift(-10.0f);
            }
            if (Keyboard.isKeyDown(3)) {
                this.gc.getSoundController().setGainShift(4.0f);
            }
            moveGrace = 0;
            enemyMoving = true;
        } else {
            ++moveGrace;
        }
        if (moveGrace == 5) {
            enemyMoving = false;
        }
        return enemyMoving;
    }

    public void enemyDeletion() {
        int i = 0;
        while (i < this.enemies.size()) {
            int j = 0;
            while (j < this.enemies.size()) {
                float dy;
                float dx;
                float dist;
                if (i != j && (dist = (float)Math.sqrt((dx = (float)Math.pow(this.enemies.get((int)i).x - this.enemies.get((int)j).x, 2.0)) + (dy = (float)Math.pow(this.enemies.get((int)i).y - this.enemies.get((int)j).y, 2.0)))) < 1.0f) {
                    this.enemies.get(i).age10();
                }
                ++j;
            }
            if (this.enemies.get(i).getLife() <= 0.0f) {
                this.delete(this.enemies.get(i));
            }
            ++i;
        }
    }

    public float getYVel() {
        return yVel;
    }

    public float getXVel() {
        return xVel;
    }

    public void isEdible(PlayerModel p) {
        float[] diffCol = new float[3];
        int i = 0;
        while (i < this.enemies.size()) {
            diffCol[0] = Math.abs(p.getPlayerColor()[0] - this.enemies.get(i).geteCol()[0]) * 255.0f;
            diffCol[1] = Math.abs(p.getPlayerColor()[1] - this.enemies.get(i).geteCol()[1]) * 255.0f;
            diffCol[2] = Math.abs(p.getPlayerColor()[2] - this.enemies.get(i).geteCol()[2]) * 255.0f;
            float diffBand = diffCol[0] + diffCol[1] + diffCol[2];
            if (diffBand < (float)Constants.bandDifference || p.isHungry()) {
                BackgroundDrawer.drawHighlight(this.enemies.get((int)i).x, this.enemies.get((int)i).y, this.enemies.get(i).getRadius(), this.enemies.get(i));
            }
            ++i;
        }
    }
}

